//---------------------------------------------------------------------------
#ifndef stereoH
#define stereoH

#include "3d.h"
#include "geometria.h"                  //TPunkt, TLinia
//---------------------------------------------------------------------------
//  Rodzaje technicznego przygotowania stereogramw
enum StylPatrzenia {
    Zezem,                              //Lewy obrazek z prawej strony i odwrotnie
    Peryskopy,                          //Lewy z lewej, prawy z prawej
    Anaglif};                           //dwa obrazki w tym samym miejscu, wymagane okulary
//---------------------------------------------------------------------------
//  Postrzeganie dwuoczne.
class TStereo
{
 private:
    T3d *L, *R;                         //projekcje dla lewego i prawego oka
    TCanvas *cnv;
 public:
    TStereo( TPunkt obs,                //pozycja obserwatora
        int xe0, int ye0, int eszer, int ewys,  //okno ekranowe
        double baza,                    //odlego midzy oczami
        TCanvas *cnv,                   //aparat graficzny
        StylPatrzenia sp=Zezem,         //typ okularw stereo
        double odl_ekr=0.5);
    ~TStereo();                         //destruktor zlikwiduje obiekty spod wskanikw L, R
    bool punkt_stereo( TPunkt p,
        TColor Lkolor=clBlack, TColor Rkolor=clBlack);
    bool linia_stereo( TPunkt p1, TPunkt p2,
        TColor Lkolor=clBlack, TColor Rkolor=clBlack);
    bool czworokat_stereo( TPunkt p1, TPunkt p2, TPunkt p3, TPunkt p4,
        TColor Lkolor1=clBlack, TColor Rkolor1=clBlack,     //kolory konturw
        TColor Lkolor2=clWhite, TColor Rkolor2=clWhite);    //kolory wypenie
};
#endif
